/* 
Statistik 7 (Vorlufige Schutzmanahmen) ab Berichtsjahr 2023
*/

select   to_number(to_char(m.bisdatum,'yyyy')) as "Berichtsjahr",
         v.bereich as "Bereich",
         v.aktenzeichen as "Aktenzeichen",
         nvl(u.name,'') as "Sachbearbeiter",
         a.nachname as "Nachname_JM",
         a.vorname as "Vorname_JM",
         to_char(p.geburtsdatum,'dd.mm.yyyy') as "GebDatJM",
         to_char(m.vondatum,'dd.mm.yyyy') as "Beginn",
         to_char(m.bisdatum,'dd.mm.yyyy') as "Ende", 
         
         substr(s.feld,13,5) as "LfdNr",
         substr(s.feld,18,20) as "Kennnummer" ,

-- Abschnitt Art des Trgers und der Manahme

(case when substr(s.feld,38,1) = '1' then 'Trger der ffentlichen Jugendhilfe'
      when substr(s.feld,38,1) = '2' then 'Trger der freien Jugendhilfe'
      else '(Angabe fehlt)' end) as "Art des Trgers",


(case when substr(s.feld,39,1) = '1' then 'Inobhutnahme  42 SGB VIII'
      when substr(s.feld,39,1) = '2' then 'Vorlufige Inobhutnahme  42a SGB VIII'
      else '(Angabe fehlt)' end) as "Art der Manahme",

(case when substr(s.feld,40,1) = '1' then 'ja'
      when substr(s.feld,40,1) = '2' then 'nein'
      else '(Angabe fehlt)' end) as "Vorh GefEinsch",
      
-- Abschnitt Angaben zum Kind oder Jugendlichen

(case when substr(s.feld,41,1) = '1' then 'mnnlich'
      when substr(s.feld,41,1) = '2' then 'weiblich'
      when substr(s.feld,41,1) = '3' then 'divers'
      when substr(s.feld,41,1) = '7' then 'ohne Angabe (nach Geburtenregister)'
      else '(Angabe fehlt)' end) as "Geschlecht",

(case when substr(s.feld,42,1) = '1' then 'unter 3 Jahren'
      when substr(s.feld,42,1) = '2' then '3 bis unter 6 Jahren'
      when substr(s.feld,42,1) = '3' then '6 bis unter 9 Jahren'
      when substr(s.feld,42,1) = '4' then '9 bis unter 12 Jahren'
      when substr(s.feld,42,1) = '5' then '12 bis unter 14 Jahren'
      when substr(s.feld,42,1) = '6' then '14 bis unter 16 Jahren'
      when substr(s.feld,42,1) = '7' then '16 bis unter 18 Jahren'
      else '(Angabe fehlt)' end) as "Alter",

(case when substr(s.feld,43,1) = '1' then 'ja'
      when substr(s.feld,43,1) = '2' then 'nein'
      else '(Angabe fehlt)' end) as "Ausl. Herk. Elternteil",

(case when substr(s.feld,44,1) = '1' then 'Deutsch'
      when substr(s.feld,44,1) = '2' then 'Nicht deutsch'
      else '(Angabe fehlt)' end) as "Vorrang. Sprache",

(case when substr(s.feld,45,1) = '1' then 'Ja'
      when substr(s.feld,45,1) = '2' then 'Nein'
      else '(Angabe fehlt)' end) as "Wiederholte ION",

(case when substr(s.feld,46,2) = '01' then 'bei den Eltern'
      when substr(s.feld,46,2) = '02' then 'bei einem Elternteil mit Partner/-in'
      when substr(s.feld,46,2) = '03' then 'bei einem allein erziehendem Elternteil'
      when substr(s.feld,46,2) = '04' then 'bei Verwandten'
      when substr(s.feld,46,2) = '05' then 'in einer Pflegefamilie ( 33, 35a SGB VIII)'
      when substr(s.feld,46,2) = '06' then 'bei einer sonstigen Person'
      when substr(s.feld,46,2) = '07' then 'in einem Heim/einer sonstigen betreuten Wohnform ( 34, 35a SGB VIII)'
      when substr(s.feld,46,2) = '08' then 'in einer eigenen Wohnung/Wohngemeinschaft'
      when substr(s.feld,46,2) = '09' then 'in einer Aufnahmeeinrichtung/Gemeinschaftsunterkunft ( 44, 53 AsylG)'
      when substr(s.feld,46,2) = '10' then 'ohne feste Unterkunft'
      when substr(s.feld,46,2) = '11' then 'unbekannt/keine Angabe mglich'
      when substr(s.feld,46,2) = '12' then 'in einem Krankenhaus (nur bei anonymer Geburt/Babyklappe)'
      else '(Angabe fehlt)' end) as "Aufenth vor Manahme",

-- Abschnitt Angaben zu Beratung

(case when substr(s.feld,48,1) = '1' then 'bei einer geeigneten Person'
      when substr(s.feld,48,1) = '2' then 'in einer Einrichtung'
      when substr(s.feld,48,1) = '3' then 'in einer sonstigen betreuten Wohnform'
      else '(Angabe fehlt)' end) as "Unterbr whrend Man",

(case when substr(s.feld,49,2) = '01' then 'Minderjhrige/-r selbst'
      when substr(s.feld,49,2) = '02' then 'Eltern(-teil)/Personensorgeberechtigte/-r'
      when substr(s.feld,49,2) = '03' then 'Jugendamt/Sozialer Dienst'
      when substr(s.feld,49,2) = '04' then 'Polizei/Gericht/Staatsanwaltschaft'
      when substr(s.feld,49,2) = '05' then 'Schule'
      when substr(s.feld,49,2) = '06' then 'Gesundheitspersonal/Gesundheitswesen'
      when substr(s.feld,49,2) = '07' then 'Verwandte'
      when substr(s.feld,49,2) = '08' then 'Sonstige'
      when substr(s.feld,49,2) = '09' then 'Kindertageseinrichtung/Kindertagespflegeperson'
      when substr(s.feld,49,2) = '10' then 'Andere Einrichtung/anderer Dienst der Kinder- und Jugendhilfe'
      when substr(s.feld,49,2) = '11' then 'Bekannte/Nachbarn'
      when substr(s.feld,49,2) = '12' then 'Anonyme Meldung'
      else '(Angabe fehlt)' end) as "Hinweisg.Inst/Person",

(case when substr(s.feld,51,1) = '1' then 'Montag bis Freitag (ohne Feiertage)'
      when substr(s.feld,51,1) = '2' then 'Samstag, Sonntag und Feiertage'
      else '(Angabe fehlt)' end) as "Beginn Manahme",

(case when substr(s.feld,52,1) = '1' then '8 - 17 Uhr'
      when substr(s.feld,52,1) = '2' then '17 - 21 Uhr'
      when substr(s.feld,52,1) = '3' then '21 - 8 Uhr'
      else '(Angabe fehlt)' end) as "Beginnzeit Manahme",

(case when substr(s.feld,53,4) <> '   ' then substr(s.feld,53,4)
      else '(Angabe fehlt)' end) as "Dauer Ma. (Tage)",

(case when substr(s.feld,57,1) = '1' then 'jugendgefhrd. Ort nach vorh. Ausreien'
      when substr(s.feld,57,1) = '2' then 'jugendgefhrd. Ort ohne vorh. Ausreien'
      when substr(s.feld,57,1) = '3' then 'sonstiger Zugang nach vorh. Ausreien'
      when substr(s.feld,57,1) = '4' then 'sonstiger Zugang ohne vorh. Ausreien'
      else '(Angabe fehlt)' end) as "Anlass der Manahme",

(case when substr(s.feld,58,1) = '1' then 'ja' else 'nein' end) as "Integr.Prob",
(case when substr(s.feld,59,1) = '1' then 'ja' else 'nein' end) as "berf_Elt",
(case when substr(s.feld,60,1) = '1' then 'ja' else 'nein' end) as "SchulAusbPr",
(case when substr(s.feld,61,1) = '1' then 'ja' else 'nein' end) as "Vernachl",
(case when substr(s.feld,62,1) = '1' then 'ja' else 'nein' end) as "DelinqStraft",
(case when substr(s.feld,63,1) = '1' then 'ja' else 'nein' end) as "Suchtprobleme",
(case when substr(s.feld,64,1) = '1' then 'ja' else 'nein' end) as "Anz.krpMissh",
(case when substr(s.feld,65,1) = '1' then 'ja' else 'nein' end) as "Anz.psyMissh",
(case when substr(s.feld,66,1) = '1' then 'ja' else 'nein' end) as "Anz.sexGewalt",
(case when substr(s.feld,67,1) = '1' then 'ja' else 'nein' end) as "TrScheidgElt",
(case when substr(s.feld,68,1) = '1' then 'ja' else 'nein' end) as "Wohnungsprob",
(case when substr(s.feld,69,1) = '1' then 'ja' else 'nein' end) as "unbeglEinr",
(case when substr(s.feld,70,1) = '1' then 'ja' else 'nein' end) as "Beziehungsprob",
(case when substr(s.feld,71,1) = '1' then 'ja' else 'nein' end) as "sonstige Prob",


(case when substr(s.feld,72,1) = '1' then 'Ja, wurde eingelegt'
      when substr(s.feld,72,1) = '2' then 'Nein, wurde nicht eingelegt'
      else '(Angabe fehlt)' end) as "Widerspruch",

(case when substr(s.feld,73,1) = '1' then 'Ja, wurde herbeigefhrt'
      when substr(s.feld,73,1) = '2' then 'Nein, wurde nicht herbeigefhrt'
      else '(Angabe fehlt)' end) as "EntscheidungFamG",

(case when substr(s.feld,74,2) in ('1 ',' 1') then 'Entscheidung JA zum anschl.Aufenth./weiteren Hilfen'
      when substr(s.feld,74,2) in ('2 ',' 2') then 'bernahme durch anderes JA (Zustndigkeitswechsel)'
      when substr(s.feld,74,2) = ' 5' then 'bernahme in eine ION nach  42 SGB VIII'
      when substr(s.feld,74,2) = ' 6' then 'Feststellung der Volljhrigkeit nach  42f SGB VIII'
      when substr(s.feld,74,2) in ('3 ',' 3') then 'Beendigung durch Mdj. selbst (z.B. Ausreien)'
      when substr(s.feld,74,2) in ('4 ',' 4') then 'keine der zuvor genannten Antworten (z.B. berfhrung in JVA)'
      else '(Angabe fehlt)' end) as "Man.endete mit",

(case when substr(s.feld,76,1) = '1' then 'am gleichen Ort wie vor der Man.'
      when substr(s.feld,76,1) = '2' then 'an anderem Ort wie vor der Man.'
      else '(Angabe fehlt)' end) as "Man.endeUnterbr.",

(case when substr(s.feld,77,2) = '01' then 'bei den Eltern (auch Fam.zusammenfhrung)'
      when substr(s.feld,77,2) = '02' then 'bei einem Elternteil mit Partner/-in'
      when substr(s.feld,77,2) = '03' then 'bei einem alleinerziehenden Elternteil'
      when substr(s.feld,77,2) = '04' then 'bei Verwandten'
      when substr(s.feld,77,2) = '05' then 'in einer (anderen) Pflegefamilie ( 33, 35a SGB VIII)'
      when substr(s.feld,77,2) = '06' then 'bei einer (anderen) sonstigen Person'
      when substr(s.feld,77,2) = '07' then 'in einer (anderen) eigenen Wohnung/Wohngemeinschaft'
      when substr(s.feld,77,2) = '08' then 'in einer Aufnahmeeinrichtung/Gemeinschaftsunterkunft ( 44, 53 AsylG)'
      when substr(s.feld,77,2) = '09' then 'in einem (anderen) Heim/einer sonstigen betreuten Wohnform / 34, 35a SGB VIII)'
      when substr(s.feld,77,2) = '10' then 'in einer sonstigen Einrichtung'
      else '(Angabe fehlt)' end) as "Unterbr.n.ManEnde",

(case when substr(s.feld,78,1) = '1' then 'ja' else 'nein' end) as "Fortf.Erz.ber",
(case when substr(s.feld,79,1) = '1' then 'ja' else 'nein' end) as "Fortf.amb./teilstat.",
(case when substr(s.feld,80,1) = '1' then 'ja' else 'nein' end) as "Fortf.and.amb./teilstat",
(case when substr(s.feld,81,1) = '1' then 'ja' else 'nein' end) as "Fortf.vorberg. stat",
(case when substr(s.feld,82,1) = '1' then 'ja' else 'nein' end) as "KeineFortf./keine",

(case when substr(s.feld,83,1) = '1' then 'ja' else 'nein' end) as "Neue Erz.ber",
(case when substr(s.feld,84,1) = '1' then 'ja' else 'nein' end) as "Neue amb./teilstat",
(case when substr(s.feld,85,1) = '1' then 'ja' else 'nein' end) as "Neue and.amb./teilstat",
(case when substr(s.feld,86,1) = '1' then 'ja' else 'nein' end) as "Neue vorberg. stat.",
(case when substr(s.feld,87,1) = '1' then 'ja' else 'nein' end) as "Keine neue/keine",

nvl((case when s.freigabe = '0' then 'nein'
      when s.freigabe = '1' then 'ja'
      end),'') as "freigegeben",

nvl((case when s.uebergabe = '0' then 'nein'
      when s.uebergabe = '1' then 'ja'
      end),'') as "bergeben"
      
from  n_vorgang v left join n_benutzer u on v.sachbearbeiter = u.lfdnr
                  inner join n_vorgbeteiligte b on v.vorgangsnummer = b.vorgang and b.beteiligtenart = 7
                  inner join n_adressen a on b.adresse = a.adressnummer
                  inner join n_personendaten p on b.adresse = p.zuordnungsnummer
                  inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                  inner join n_massnahme m on h.massnahme = m.massnahmennummer
                  inner join n_statistikbogen s on h.massnahme = s.aktion      

where to_number(to_char(m.bisdatum,'yyyy')) >= 2023

order by 1,3,4,5,6